'=============================================================================
'                           RAYCASTING TUTORIAL #3
'                                By Joe King
'
'                         How to make a map grid work
'=============================================================================

'   All right, now we now the idea of raycasting, and how to cast out rays by
' using the slopes.  Now we are ready to do some more stuff.  Let's construct
' our map grid for our raycasting.  Let's make the map grid 10X10.  Let's
' make the 1's on the map grid walls, and the 0's nothing, and the 2 is where
' you are.  Like this map grid below.

1111111111
1000000001
1001011101
1111000101
1000020101
1000000001
1111010001
1000010101
1011110001
1111111111

'   You can see the enviroment we will be making into a 3d image.  Your
' position is 5,5.  That's where the 2 is on the map.  Remember that the 1's
' are walls, and the 0's are nothing, and that the 2 is your starting
' position.  We will be casting out rays from your position on the map grid.
' If the ray hits a 1 on the map grid, we will stop the ray, get the distance
' to the wall, and put it on the screen.

'   We will add the y-axis on the map grid by the rise, and the x-axis on the
' map grid by the run.  We can make the rise and run(slopes) single precision
' variables(decimal numbers), but adding single precision numbers takes alot
' longer then adding integers, so let's use integers for our slopes.  When we
' calculate the slopes and store them in our tables, they will round to a
' whole number since they are integers.  Since all the slopes revolve around
' 1, they will all round to 1 or 0.  So when we calculate the slopes to store
' in our tables, we will times them by a certain number.  100 works fine, but
' if the run of our slope was 80, it would run off the map when we add the run
' by the x-axis on the map grid.  So we will do a little trick.  We will times
' our position on the map by 1000.  If our x position on the map was 5,
' 5*100 = 5000, so when we add 80 to our x position, it would by 5000+80, or
' 5080, they to check if we hit a wall, we divide the new position by 1000.
' 5080/1000 = 5.08 and it will round of to 5(which is not off of the 10X10 map
' grid), that's the position of where the ray is at now.
'   We keep on adding the slopes until we hit a wall.  So if the
' ray was at 2400,4500, then divide them by 1000, 2400/1000,4500/1000 =
' 2.4,4.5, then it would round of and be 2,5.  On the map we would check it by
' IF MAP(RAYX/1000,RAYY/1000) = 1 THEN, then we would get the distance to the
' wall and put a line on the screen according to where it is, and how far away
' it is.

'   Now, when we put up the line on the screen, we put it up according to what
' angle your casting at, and by how far away it is.  We will use Graphics mode
' 13h for our raycasting, which had a resolution of 320X200.  If we put up a
' line for each ray we cast out, we would have 60 of them since our F.O.V. is
' 60.  But that dosen't fill the entire screen.  For now, we will stretch out
' our lines and make each line 5 wide, 60*5 = 300, but there's still 20 pixels
' left to fill, so we will use a 64 F.O.V.(64*5 = 320), that will cover the
' entire screen.  Later on, in tutorial #5, I will tell you how to cast out
' 320 rays for your 60 degree F.O.V., but for now, will use the way I've just
' explained.
'   To put up our thick lines on the screen, we will start at the left or our
' screen and at the left of our F.O.V. We will cast out a ray, then put up the
' vartical strip on the screen, then go to the next ray, and go to the right
' on the screen 5 pixels(since the width of our vertical line is 5), then cast
' out a ray again, then keep on doing that until we covered our 64 F.O.V.

'   Now I think we are ready to do some raycasting, go on to the next
' tutorial, there will be some code for raycasting with lots of REM
' statments.  So if you get this part of the tutorial, let's move on to
' tutorial #4.

'***** Sorry, no code for this tutorial *****

